// Author      : Esteban Marin - estebanmarin@gmx.ch
// Version     : 2.0
// License     : GNU LGPL (http://www.gnu.org/copyleft/lesser.html)
// 	----------------------------------------------------------------------------
//  Copyright (C) Esteban Marin
// 	
// 	This program is free software: you can redistribute it and/or modify
// 	it under the terms of the GNU Lesser General Public License as published by
// 	the Free Software Foundation, either version 2.1 of the License, or
// 	(at your option) any later version.
// 	
// 	This program is distributed in the hope that it will be useful,
// 	but WITHOUT ANY WARRANTY; without even the implied warranty of
// 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// 	GNU Lesser General Public License for more details.
// 	
// 	You should have received a copy of the GNU Lesser General Public License
// 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 	
// 	See LICENSE.TXT file for more information.
//  ----------------------------------------------------------------------------
//
function decryptCharcode(n,start,end,offset)	{
	n = n + offset;
	if (offset > 0 && n > end)	{
		n = start + (n - end - 1);
	} else if (offset < 0 && n < start)	{
		n = end - (start - n - 1);
	}
	return String.fromCharCode(n);
}
	// decrypt string
function decryptString(enc,offset)	{
	var dec = "";
	var len = enc.length;
	for(var i=0; i < len; i++)	{
		var n = enc.charCodeAt(i);
		if (n >= 0x2B && n <= 0x3A)	{
			dec += decryptCharcode(n,0x2B,0x3A,offset);	// 0-9 . , - + / :
		} else if (n >= 0x40 && n <= 0x5A)	{
			dec += decryptCharcode(n,0x40,0x5A,offset);	// A-Z @
		} else if (n >= 0x61 && n <= 0x7A)	{
			dec += decryptCharcode(n,0x61,0x7A,offset);	// a-z
		} else {
			dec += enc.charAt(i);
		}
	}
	return dec;
}
	// decrypt spam-protected emails
function linkTo_UnCryptMailto(s)	{
	location.href = decryptString(s,-2);
}/*
function MakeLayer(ID,Title, Content)
{
	
	var el = document.createElement("div");
	el.id = ID;
	el.style.position = "absolute";
	el.style.zIndex = zindex;
}*/
function hidelayer(layer){
	if(document.getElementById(layer).style.visibility != 'hidden'){
		document.getElementById(layer).style.visibility = 'hidden';
		
		document.getElementById(layer).style.top = '-3000px';
		var hidelayerzindex = 0;
		hidelayerzindex = parseInt(document.getElementById('hidelayer').style.zIndex);
		if(hidelayerzindex > 2){
				document.getElementById('hidelayer').style.zIndex = hidelayerzindex-2;
				document.getElementById('hidelayer').style.visibility = 'visible';
		}
		else{
			
				document.getElementById('hidelayer').style.visibility = 'hidden';
				document.getElementById('hidelayer').style.zIndex = 0;
		}
	}
}
function showlayer(layer){
	document.getElementById(layer).style.visibility = 'visible';
	
	document.getElementById(layer).style.top = '';
	var hidelayerzindex = 0;
	hidelayerzindex = parseInt(document.getElementById('hidelayer').style.zIndex);
	if(hidelayerzindex >= 2){
			document.getElementById('hidelayer').style.zIndex = parseInt(hidelayerzindex)+2;
	}
	else{
			document.getElementById('hidelayer').style.visibility = 'visible';
			document.getElementById('hidelayer').style.zIndex = 2;
	}
	document.getElementById(layer).style.zIndex = hidelayerzindex+3;
}
function FavoritesController()
{
	var that = this;
	this.el = document.getElementById('Favorites');
	Dom = YAHOO.util.Dom;
	Event = YAHOO.util.Event;
	DDM = YAHOO.util.DragDropMgr;
	
	this.DDList = function(id, sGroup, config) {

	    that.DDList.superclass.constructor.call(this, id, sGroup, config);
	
	    this.logger = this.logger || YAHOO;
	    var el = this.getDragEl();
	    Dom.setStyle(el, "opacity", 0.67); // The proxy is slightly transparent
	
	    this.goingUp = false;
	    this.lastY = 0;
	};
	this.init = function()
	{
		YAHOO.extend(that.DDList, YAHOO.util.DDProxy, {
	
		    startDrag: function(x, y) {
			
			// make the proxy look like the source element
			var dragEl = this.getDragEl();
			var clickEl = this.getEl();
			Dom.setStyle(clickEl, "visibility", "hidden");
		
			dragEl.innerHTML = clickEl.innerHTML;
		
			Dom.setStyle(dragEl, "color", Dom.getStyle(clickEl, "color"));
			Dom.setStyle(dragEl, "font-size", '0.9em');
			Dom.setStyle(dragEl, "backgroundColor", Dom.getStyle(clickEl, "backgroundColor"));
			Dom.setStyle(dragEl, "border", "2px solid gray");
		    },
		
		    endDrag: function(e) {
		
			var srcEl = this.getEl();
			var proxy = this.getDragEl();
		
			// Show the proxy element and animate it to the src element's location
			Dom.setStyle(proxy, "visibility", "");
			
			var proxyid = proxy.id;
			var thisid = this.id;
		
			// Hide the proxy and show the source element when finished with the animation
			Dom.setStyle(proxyid, "visibility", "hidden");
			Dom.setStyle(thisid, "visibility", "");
			Dom.setXY(proxyid);
			
		    },
		
		    onDragDrop: function(e, id) {
		
			// If there is one drop interaction, the li was dropped either on the list,
			// or it was dropped on the current location of the source element.
			if (DDM.interactionInfo.drop.length === 1) {
		
			    // The position of the cursor at the time of the drop (YAHOO.util.Point)
			    var pt = DDM.interactionInfo.point; 
		
			    // The region occupied by the source element at the time of the drop
			    var region = DDM.interactionInfo.sourceRegion; 
		
			    // Check to see if we are over the source element's location.  We will
			    // append to the bottom of the list once we are sure it was a drop in
			    // the negative space (the area of the list without any list items)
			    if (!region.intersect(pt)&&id!="bin") {
				var destEl = Dom.get(id);
				var destDD = DDM.getDDById(id);
				destEl.appendChild(this.getEl());
				destDD.isEmpty = false;
				DDM.refreshCache();
			    }
			    else if(id=="bin")
			    {
				document.getElementById('binlist').appendChild(this.getEl());
				document.getElementById('binlist').innerHTML = '';
				that.setCookie();
				if(that.el.childNodes.length<1) that.hide();
				
				DDM.refreshCache();
			    }
		
			}
		    },
		
		    onDrag: function(e) {
		
			// Keep track of the direction of the drag for use during onDragOver
			var y = Event.getPageY(e);
		
			if (y < this.lastY) {
			    this.goingUp = true;
			} else if (y > this.lastY) {
			    this.goingUp = false;
			}
		
			this.lastY = y;
		    },
		
		    onDragOver: function(e, id) {
		    
			var srcEl = this.getEl();
			var destEl = Dom.get(id);
		
			// We are only concerned with list items, we ignore the dragover
			// notifications for the list.
			if (destEl.nodeName.toLowerCase() == "li") {
			    var orig_p = srcEl.parentNode;
			    var p = destEl.parentNode;
		
			    if (this.goingUp) {
				p.insertBefore(srcEl, destEl); // insert above
			    } else {
				p.insertBefore(srcEl, destEl.nextSibling); // insert below
			    }
		
			    DDM.refreshCache();
			}
			else if(id=="bin")
			{
				destEl.src="inc/img/bin_glow.png";
			}
		    },
		    onDragOut: function(e, id) {
		    
			
		
			if(id=="bin")
			{
				var destEl = Dom.get(id);
				destEl.src="inc/img/bin.png";
			}
		    }
		    
		    
		});
		var rows=that.el.childNodes.length,i;
		
		var ListTarget = new YAHOO.util.DDTarget("Favorites");
		var BinTarget = new YAHOO.util.DDTarget("bin");
	
		    for (i=0;i<rows;i=i+1) {
			    
			new that.DDList(that.el.childNodes[i].id);
		    }
	}	
	this.init();
	this.learn = function()
	{
		
	}
	
	
	this.add = function(ID,Name,Mode,Random)
	{
		var found = false;
		for(i in that.el.childNodes)
		{
			
			if(that.el.childNodes[i]&&that.el.childNodes[i].id&&that.el.childNodes[i].id==ID)
			{
				found = true;
				break;
			}
		}
		if(!found)
		{
			if(typeof Mode=="undefined" || Mode!="l2l1") Mode = "l1l2";
			if(Random) Random = 1;
			else Random = 0;
			var li = document.createElement("li");
			li.id = ID;
			li.innerHTML = Name;
			li.className = Mode+"."+Random;
			that.el.appendChild(li);
			new that.DDList(that.el.lastChild.id);
		}
		that.show();
		that.setCookie();
	}
	this.deleteAll = function()
	{
		that.el.innerHTML = "";
		that.setCookie();
		that.hide();
	}
	this.hide = function()
	{
		document.getElementById("FavoritesWrapper").style.display = "none";
	}
	this.show = function()
	{
		if(document.getElementById("FavoritesWrapper"))
		{
			document.getElementById("FavoritesWrapper").style.display = "block";
		}
	}
	this.setCookie = function()
	{
		var today = new Date();
		today.setTime( today.getTime() );
		var list = [];
		var arr = that.getList();
		for(i in arr)
		{
			list[i] = arr[i][0]+"."+arr[i][1]+"."+arr[i][2];
		}
		var expires_date = new Date( today.getTime() + 1000 * 60 * 60 * 24 * 90 );
		
		document.cookie = "FavoriteList" + "=" +escape( list.join(";") ) +
		( ";expires=" + expires_date.toGMTString()) +
		(  ";path=/") ;
		//( ( domain ) ? ";domain=" + domain : "" ) +
		
	}
	this.getList = function()
	{
		var arr = [];
		for(i in that.el.childNodes)
		{
			if(that.el.childNodes[i]&&that.el.childNodes[i].id&&that.el.childNodes[i].className)
			{
				var pos = arr.length;
				var Mode = that.el.childNodes[i].className.split(".")[0];
				var Random = that.el.childNodes[i].className.split(".")[1];
				var Name = that.el.childNodes[i].innerHTML;
				arr[pos] = [that.el.childNodes[i].id,Mode,Random];
				
			}
		}
		return arr;
	}
}
function RedoMistakes()
{
	if(document.getElementById('LearnForm'))
	{
		form = document.getElementById('LearnForm');
		form.Relearn.value = 1;
		form.WordID.value = 0;
		form.RelearnItemsDone.value = '';
		form.submit();
	}
}
function Reset()
{
	if(document.getElementById('LearnForm'))
	{
		form = document.getElementById('LearnForm');
		form.Relearn.value = 0;
		form.WordID.value = 0;
		form.RelearnItems.value = '';
		form.Relearn.value = 0;
		form.RelearnItemsDone.value = '';
		form.WordsDone.value = '';
		
		form.submit();
	}
}
function LearnList(ListID,Mode,Shuffle)
{
	if(document.getElementById('LearnForm'))
	{
		form = document.getElementById('LearnForm');
		form.Relearn.value = 0;
		form.WordID.value = 0;
		form.LearnListID.value = ListID;
		form.RelearnItems.value = '';
		form.Relearn.value = 0;
		if(Shuffle==1)
		{
			form.shuffle.checked = true;
		}
		else
		{
			form.shuffle.checked = false;
		}
		if(Mode=="l1l2")
		{
			form.mode[0].checked = true;
			form.mode[1].checked = false;
		}
		else
		{
			form.mode[0].checked = false;
			form.mode[1].checked = true;	
		}
		form.RelearnItemsDone.value = '';
		form.submit();
	}
}
PromptPWSubmitAction = function(){};
function PromptPassword(SubmitAction)
{
	showlayer('TypePW');
	form = document.getElementById("TypePWForm");
	form.SavePW.onclick = SubmitAction;
	PromptPWSubmitAction = SubmitAction;
	form.PW.value = "";
	form.PW.focus();
}
function AJAXRequest(Page,Async){
	if(typeof Page !="undefined" && Page!=""){
		
		var http_request = false;
		// check native support first
		if(window.XMLHttpRequest) {
			http_request = new XMLHttpRequest();
		}else{
			// check for version 6 before version 3
			try{ 
				http_request = new ActiveXObject("MSXML2.XMLHTTP.6.0");  
			}catch(e){
				
			}
			try{ 
				if(!http_request) transport = new ActiveXObject("MSXML2.XMLHTTP");  
			}catch(e){
			
			}
		}
		
		http_request.open("POST",Page, true);
		try{
			http_request.overrideMimeType('text/xml');
		}
		catch (ie){
		}
		http_request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
		return http_request;
	}
	else return false;
}
function AddNewList(form)
{
	if(form.NewListName.value!=''&&form.NewListCategoryID.value>0)
	{
		if(CheckForCategoryPW(form.NewListCategoryID))
		{
			PromptPassword(function(){
				document.getElementById('AddNewListForm').NewListCategoryPW.value = document.getElementById('TypePWForm').PW.value;
				document.getElementById('AddNewListForm').submit();
				return false;
			});
		}
		else
		{
			form.submit();
		}
	}
	else if(form.NewListName.value!='')
	{
		alert("Bitte Listenbezeichnung eingeben!");
	}
	else alert("Bitte Kategorie auswählen!");
}
function EditList(form)
{
	if(form.EditListID.value>0&&form.EditListCategoryID.value>0)
	{
		if(CheckForCategoryPW(form.EditListCategoryID))
		{
			PromptPassword(function(){
				document.getElementById('EditListForm').EditListCategoryPW.value = document.getElementById('TypePWForm').PW.value;
				document.getElementById('EditListForm').submit();
				return false;
			});
		}
		else
		{
			form.submit();
		}
	}
	else if(!(form.EditListID.value>0))
	{
		alert("Bitte Liste auswählen!");
	}
	else alert("Bitte Kategorie auswählen!");
}
function DeleteList(form)
{
	if(form.DeleteListID.value>0&&form.DeleteListCategoryID.value>0)
	{
		if(CheckForCategoryPW(form.DeleteListCategoryID))
		{
			PromptPassword(function(){
				document.getElementById('DeleteListForm').DeleteListCategoryPW.value = document.getElementById('TypePWForm').PW.value;
				document.getElementById('DeleteListForm').submit();
				return false;
			});
		}
		else
		{
			form.submit();
		}
	}
	else if(!(form.DeleteListID.value>0))
	{
		alert("Bitte Liste auswählen!");
	}
	else alert("Bitte Kategorie auswählen!");
}
function CheckForCategoryPW(SelectEl)
{
	return SelectEl.options[SelectEl.selectedIndex].className=="pw";
}
function AddEditCheckForPW()
{
	var SelectEl = document.getElementById('CategoryID');
	if(CheckForCategoryPW(SelectEl))
	{
		PromptPassword(function(){});
	}
}
function ParseDate(InputDate,DateFormat){
	var OutputDate = true;
	var Separator = "";
	var ValidateDay = true;
	var ValidateMonth = true;
	var ValidateYear = true;
	var ArrLength = 0;
	var YearOffset = 0;
	var Day = "1";
	var Month = "1";
	var Year = "2009";
	
	if(DateFormat=="dmy"){
		ArrLength = 3;
		ValidateDay = true;
		ValidateMonth = true;
	}
	else if(DateFormat == "my"){
		ArrLength = 2;
		ValidateDay = false;
		ValidateMonth = true;
	}
	else if(DateFormat == "dm"){
		if(InputDate.split(".").length==3||InputDate.split("-").length==3||InputDate.split("/").length==3)
		{
			ArrLength = 3;
		}
		else
		{
			ArrLength = 2;
		}
		ValidateDay = true;
		ValidateMonth = true;
		ValidateYear = false;
	}
	else if(DateFormat == "y"){
		ArrLength = 1;
		Separator = false;
		ValidateDay = false;
		ValidateMonth = false;
	}
	else OutputDate = false;
	
	
	if(ArrLength>1){
		if(InputDate.split(".").length==ArrLength)
		{
			Separator = ".";
		}
		else if(InputDate.split("-").length==ArrLength)
		{
			Separator = "-";
		}
		else if(InputDate.split("/").length==ArrLength)
		{
			Separator = "/";
		}
		else if(InputDate.length==2||InputDate.length==4||InputDate.length==6||InputDate.length==8)
		{
			Separator = "";
		}
		else OutputDate = false;
	}
	
	if(Separator!==""&&Separator!==false){
		Arr = InputDate.split(Separator);
		if(ValidateYear === true)
		{ 
			Year = Arr[ArrLength-1];
		}
		if(ValidateMonth === true){
			Month = Arr[ArrLength-2];
		}
		if(ValidateDay===true){
			Day = Arr[0];
		}
		
		
	}
	else if(InputDate.length == 6||InputDate.length==8){
		if(InputDate.length==8)
		{
			YearOffset = 2;
		}
		if(DateFormat=="my"&&YearOffset==0){
			Year = InputDate.substring(2,6);
			Month = InputDate.substring(0,2);
		}
		else if(DateFormat == "dmy"){
			Year = InputDate.substring(4,6+YearOffset);
			Month = InputDate.substring(2,4);
			Day = InputDate.substring(0,2);
		}
		else OutputDate = false;
	}
	else if(InputDate.length==4){
		if(DateFormat == "y")
		{
			Year = InputDate;
		}
		else if(DateFormat == "dm")
		{
			Month = InputDate.substring(2,4);
			Day = InputDate.substring(0,2);
		}
		else OutputDate = false;
	}
	else if(InputDate.length==2&&DateFormat == "y"){
		Year = InputDate;
	}
	else OutputDate = false;
	
		
	if(Year.length==2){
		if(Year.substring(0,1)=="0")
		{
			Year = Year.substring(1,2);
		}
		Year = parseInt(Year) + 2000;
	}
	else if(Year.length==4){
		
	}
	else OutputDate = false;
	
	if(Month.length==2&&Month.substring(0,1)=="0") Month = Month.substring(1,2);
	
	if(Day.length==2&&Day.substring(0,1)=="0") Day = Day.substring(1,2);
	
	
	if(parseInt(Year)==0||parseInt(Month)==0||parseInt(Day)==0) return false;
	
	
	if (Month < 1 || Month > 12) { // check month range
		return false;
	}
	if (Day < 1 || Day > 31) {
		return false;
	}
	if ((Month==4 || Month==6 || Month==9 || Month==11) && Day==31) {
		return false;
	}
	if (Month == 2) { // check for february 29th
		var isleap = (Year % 4 == 0 && (Year % 100 != 0 || Year % 400 == 0));
		if (Day>29 || (Day==29 && !isleap)) {
			return false;
		}
	}
	
	if(OutputDate===false)
	{
		return false;
	}
	
	var FinalDate = new Date(Year,Month-1,Day,0,0,0,0);
	if(Separator==="") Separator = ".";
	else if(Separator == false) Separator = "";
	
	return Array(FinalDate,Separator);
	
	
}
function AddNewCategoryController(RefreshElement)
{
	var that = this;
	this.Name = '';
	this.Password = '';
	this.Email = '';
	this.Duration = 1;
	
	this.LayerEl = document.getElementById("AddNewCategory");
	this.NameEl = document.getElementById("NewCategoryName");
	this.PasswordEl = document.getElementById("NewCategoryPassword");
	this.EmailEl = document.getElementById("NewCategoryEmail");
	this.DurationEl = document.getElementById("NewCategoryDuration");
	this.ValidUntilEl = document.getElementById("NewCategoryValidUntil");
	this.ValidUntilRowEl = document.getElementById("NewCategoryValidUntilRow");
	
	this.ValidUntil = ParseDate(this.ValidUntilEl.value,'dmy')[0];
	this.RefreshEl = RefreshElement;
	this.DefaultValidUntil = (this.ValidUntil.getDate()<10?"0":"")+this.ValidUntil.getDate()+"."+(this.ValidUntil.getMonth()+1<10?"0":"")+(this.ValidUntil.getMonth()+1)+"."+this.ValidUntil.getFullYear();
	this.show = function()
	{
		that.reset();
		
		showlayer("AddNewCategory");
		that.NameEl.focus();
	}
	this.reset = function()
	{
		that.NameEl.value = '';
		that.PasswordEl.value = '';
		that.EmailEl.value = '';
		that.DurationEl.selectedIndex = 0;
		that.DurationEl.options[0].selected = true;
		that.ValidUntilEl.value = that.DefaultValidUntil;
		that.setValidUntilVisibility();
	}
	this.setValidUntilVisibility = function()
	{
		if(that.DurationEl.selectedIndex == 1)
		{
			that.ValidUntilRowEl.style.display = "none";
		}
		else
		{
			that.ValidUntilRowEl.style.display = "block";
		}
	}
	this.add = function()
	{
		that.Name = that.NameEl.value;
		if(that.Name=='')
		{
			alert('Bitte Bezeichnung eingeben!');
			return;
		}
		that.Password = that.PasswordEl.value;
		that.Email = that.EmailEl.value;
		that.Duration = that.DurationEl.value;
		var tmpDate = ParseDate(that.ValidUntilEl.value,'dmy');
		if(that.Duration==1 && tmpDate === false)
		{
			alert('Bitte Datum eingeben! (Format: 24.12.2010)');
			return;
		}
		that.ValidUntil = tmpDate[0];
		http_request = AJAXRequest("AddNewCategoryAJAX.php");
		var formdata = ""+
		"Action=AddNewCategory&Name="+encodeURIComponent(that.Name)+
		"&Password="+encodeURIComponent(that.Password)+
		"&Email="+encodeURIComponent(that.Email)+
		"&Duration="+parseInt(that.Duration)+
		"&ValidUntil="+((that.ValidUntil.getTime()-that.ValidUntil.getMilliseconds())/1000);
		
		http_request.send(formdata);
		http_request.onreadystatechange = function(){
			
			if (http_request.readyState == 4) {
				var CategoryID = parseInt(http_request.responseText);
				
				if(CategoryID>0)
				{
					GetCategories(CategoryID,document.getElementById("NewListCategoryID"));
					
					that.hide();
				}
				else
				{
					alert("Fehler!");
					that.hide();
					
				}
			}
		};
		
	}
	this.hide = function()
	{
		that.reset();
		hidelayer("AddNewCategory");
	}
}
function InitAddNewCategory()
{
	
	AddNewCat = new AddNewCategoryController();
	AddNewCat.show();
	
}
function IsIE(){
	return navigator.appName == 'Microsoft Internet Explorer';
}
function GetCategories(SelectedCategoryID,SelectEl)
{
	http_request = AJAXRequest("GetListsCategoriesAJAX.php");
		var formdata = ""+
		"Action=GetCategories"+
		"&CategoryID="+encodeURIComponent(SelectedCategoryID);
		
		http_request.send(formdata);
		http_request.onreadystatechange = function(){
			
			if (http_request.readyState == 4) {
				
				var tmpEl = document.createElement("div");
				tmpEl.innerHTML = http_request.responseText;
				if(IsIE())
				{
					
					while(SelectEl.childNodes[0])
					{
						SelectEl.removeChild(SelectEl.childNodes[0]);
					}
					
					
					if(tmpEl.childNodes[0])
					{
						var selIndex = tmpEl.childNodes[0].selectedIndex;
						while(tmpEl.childNodes[0].childNodes[0])
						{
							
							tmpEl.childNodes[0].childNodes[0].selected = false;
							SelectEl.appendChild(tmpEl.childNodes[0].childNodes[0]);
							
						}
						SelectEl.childNodes[selIndex].selected = true;
						SelectEl.selectedIndex = selIndex;
					}
				}
				else
				{
					SelectEl.innerHTML = tmpEl.firstChild.innerHTML;
				}
			}
		};
}
function GetLists(CategoryID,SelectedListID,SelectEl)
{
	http_request = AJAXRequest("GetListsCategoriesAJAX.php");
		var formdata = ""+
		"Action=GetLists"+
		"&CategoryID="+encodeURIComponent(CategoryID)+
		"&ListID="+encodeURIComponent(SelectedListID);
		
		http_request.send(formdata);
		http_request.onreadystatechange = function(){
			
			if (http_request.readyState == 4) {
				
				var tmpEl = document.createElement("div");
				tmpEl.innerHTML = http_request.responseText;
				if(IsIE())
				{
					
					while(SelectEl.childNodes[0])
					{
						SelectEl.removeChild(SelectEl.childNodes[0]);
					}
					
					
					if(tmpEl.childNodes[0])
					{
						var selIndex = tmpEl.childNodes[0].selectedIndex;
						while(tmpEl.childNodes[0].childNodes[0])
						{
							
							tmpEl.childNodes[0].childNodes[0].selected = false;
							SelectEl.appendChild(tmpEl.childNodes[0].childNodes[0]);
							
						}
						SelectEl.childNodes[selIndex].selected = true;
						SelectEl.selectedIndex = selIndex;
					}
				}
				else
				{
					SelectEl.innerHTML = tmpEl.firstChild.innerHTML;
				}
			}
		};
}
