<?php
// Author      : Esteban Marin - estebanmarin@gmx.ch
// Version     : 2.0
// License     : GNU LGPL (http://www.gnu.org/copyleft/lesser.html)
// 	----------------------------------------------------------------------------
//  Copyright (C) Esteban Marin
// 	
// 	This program is free software: you can redistribute it and/or modify
// 	it under the terms of the GNU Lesser General Public License as published by
// 	the Free Software Foundation, either version 2.1 of the License, or
// 	(at your option) any later version.
// 	
// 	This program is distributed in the hope that it will be useful,
// 	but WITHOUT ANY WARRANTY; without even the implied warranty of
// 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// 	GNU Lesser General Public License for more details.
// 	
// 	You should have received a copy of the GNU Lesser General Public License
// 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 	
// 	See LICENSE.TXT file for more information.
//  ----------------------------------------------------------------------------
//
function GetHeader($Title,$AdditionalHeaders='',$DragDrop = false)
{
	return "<?xml version=\"1.0\" encoding=\"utf-8\"?>".
	"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">".
	"<html xmlns=\"http://www.w3.org/1999/xhtml\">".
		"<head>".
			"<meta http-equiv=\"X-UA-Compatible\" content=\"IE=8\" />".
			"<link href=\"inc/css/styles.css\" rel=\"stylesheet\" type=\"text/css\" />".
			"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />".
			"<title>".$Title."</title>".
			($DragDrop?"<script type=\"text/javascript\" src=\"inc/js/dragdrop.js\"></script>":'').
			"<script type=\"text/javascript\" src=\"inc/js/worddriller_v2.js\"></script>" . 
			"<meta http-equiv=\"Content-type\" value=\"text/html; charset=UTF-8\" />".
			
			$AdditionalHeaders.
		"</head>";
}
function GetBody($Content,$Width = 460,$MainPage = true,$AppendToBody = '')
{
	global $gtime;
	return ''.
	'<body>'.
		'<div class="SchoolSelector clear" >' . 
			'<form id="SelectSchoolForm" method="POST" action="wdmain.php">'.
				'<span class="Label">Schule</span>'.
				GetSchoolSelector(true,($MainPage?'style="margin-right:10px;"':'disabled="disabled" style="background-color:#DDDDDD;"').' onchange="this.form.submit();"').
				($MainPage?MakeButton("AddNewSchoolButton","neue Schule hinzuf&uuml;gen","showlayer('AddNewSchool');document.getElementById('NewSchool').focus();","button","Large",'',2):'').
			'</form>'.
		'</div>'.
		
		'<table class="ContentTable">'.
			'<tr><td class="TopLeft"></td><td class="TopCenter"></td><td class="TopRight">'.
				($MainPage===true?
					GetFavorites()
				:'').
			'</td></tr>'.
			'<tr>'.
				'<td class="MiddleLeft"><div class="SubElement"></div></td>'.
				'<td class="MiddleCenter ContentCell" style="width:'.$Width.'px;">'.
					'<div class="SubElement">'.
						'<div class="Logo">'.
							'<a href="http://www.worddriller.ch"><img src="inc/img/worddriller.png" /></a>'.
						'</div>'.
						$Content.
					'</div>'.
				'</td>'.
				'<td class="MiddleRight"><div class="SubElement"></div></td>'.
			'</tr>'.
			'<tr><td class="BottomLeft"></td><td class="BottomCenter"></td><td class="BottomRight"><div></td></tr>'.
			
		'</table>'.
		'<div style="text-align:center;margin-top:8px;">' . 
			'<span style="color:#999999;margin:5px;font-size:0.9em">worddriller v2.0</span><br />' . 
			'<span style="text-align:center;width:100%;color:#999999;font-size:0.9em;line-height:160%;">' . 
				'<a href="wdabout.php" target="_blank" style="color:#999999;">&uuml;ber worddriller</a>' . 
				 
			'</span><br />'.
			'<span style="text-align:center;width:100%;color:#999999;font-size:0.9em;line-height:160%;">' . 
				'&copy; '.date("Y",time()).' by ' . 
				'<a href="javascript:linkTo_UnCryptMailto(\'ocknvq,guvgdcpoctkpBioz0ej\');" style="color:#999999;font-weight:bold">Esteban Mar&iacute;n</a>' . 
				 
			'</span>'.
		'</div>'.
		$AppendToBody.
		'<div id="hidelayer" style="z-index:0;visibility:hidden;"></div>'.
		'<!-- generated in '.(microtime(1)-$gtime).' seconds -->' .
	'</body></html>';
	
}
function MakeBox($Title, $Content, $Width = 380,$CloseButtonAction = '')
{
	return ''.
	'<table class="BlueBox" >'.
		'<tr><td class="TopLeft"></td><td class="TopCenter"></td><td class="TopRight"></td></tr>'.
		'<tr>'.
			'<td class="MiddleLeft"></td>'.
			'<td class="MiddleCenter ContentCell" style="width:'.$Width.'px">'.
				($CloseButtonAction!=''?'<img src="inc/img/cancel.gif" width="20" height="20" onclick="'.$CloseButtonAction.'" style="position:absolute;z-index:auto;margin-left:365px;margin-top:-5px;cursor:pointer;" title="abbrechen" />':'').
				($Title!=''?'<div class="Title">'.$Title.'</div>':'').
				$Content.
			'</td>'.
			'<td class="MiddleRight"></td>'.
		'</tr>'.
		
		'<tr><td class="BottomLeft"></td><td class="BottomCenter"></td><td class="BottomRight"><div></td></tr>'.
	'</table>';
	
}
function MaskHTML($HTML)
{
	return htmlspecialchars($HTML,ENT_QUOTES,"UTF-8");
}
function GetSchoolSelector($Active=true,$Attributes = '')
{
	global $DBConnection,$SchoolID;
	
	$Select = '<select id="SchoolSelector" name="SchoolSelector" '.$Attributes.' '.($Active===false?'disabled="disabled"':'').'>';
	
	$query = "SELECT ID,Name FROM schools ORDER BY ID ASC";
	$result = $DBConnection->query($query) or die("Fehler!");
	$Options = '';
	
	
	while ($row = $result->fetch_assoc()) {
		if($SchoolID==$row["ID"]) $selected = 'selected="selected"';
		else $selected = '';
		
		$Options.='<option ' . $selected.' value="'.$row["ID"].'">'.MaskHTML($row["Name"]).'</option>';


	}
	return $Select.$Options.'</select>';

}
function GetCategorySelector($SchoolID,$CategoryID,$ID,$Attributes = '')
{
	global $DBConnection;
	$BlankMD5 = md5("");
	
	$Select = '<select id="'.$ID.'" name="'.$ID.'" '.$Attributes.'>';
	
	$query = "SELECT ID,Name,Password FROM categories WHERE SchoolID=".(int)$SchoolID." AND Deleted = 0 AND (categories.Duration=0 OR categories.Duration>".time().") ORDER BY Name ASC";
	$result = $DBConnection->query($query) or die("Fehler!");
	$Options = '<option value="">Bitte w&auml;hlen Sie eine Kategorie aus...</option>';
	
	
	while ($row = $result->fetch_assoc()) {
		if($CategoryID==$row["ID"]) $selected = 'selected="selected"';
		else $selected = '';
		if($row["Password"]!=$BlankMD5) $class="class=\"pw\"";
		else $class="class=\"nopw\"";
	
		$Options.='<option ' . $selected.' '.$class.' value="'.$row["ID"].'">'.MaskHTML($row["Name"]).'</option>';


	}
	return $Select.$Options.'</select>';
}
function GetListSelector($SchoolID,$CategoryID,$ListID,$ID,$Attributes = '')
{
	global $DBConnection;
	$BlankMD5 = md5("");
	
	$Select = '<select id="'.$ID.'" name="'.$ID.'" '.$Attributes.'>';
	
	$query = "SELECT lists.ID AS ID,lists.Name AS Name,lists.L1 AS L1,lists.L2 AS L2 FROM lists,categories WHERE categories.ID = ".(int)$CategoryID." AND categories.SchoolID = ".(int)$SchoolID." AND lists.Category=".(int)$CategoryID." AND categories.Deleted = 0 AND lists.Deleted = 0 ORDER BY lists.Name ASC";
	$result = $DBConnection->query($query) or die("Fehler!".$query);
	$Options = '';
	$L1 = '';
	$L2 = '';
	$ListSelected = false;
	$ListName = "";
	while ($row = $result->fetch_assoc()) {
		if($ListSelected === false)
		{
			$ListSelected = $row["ID"];
			$L1 = $row["L1"];
			$L2 = $row["L2"];
			$ListName = $row["Name"];
		}
		if($ListID==$row["ID"])
		{
			$ListSelected = $row["ID"];
			$L1 = $row["L1"];
			$L2 = $row["L2"];
			$selected = 'selected="selected"';
			$ListName = $row["Name"];
		}
		else $selected = '';
		
		$Options.='<option ' . $selected.' value="'.$row["ID"].'">'.MaskHTML($row["Name"]).'</option>';


	}
	if($ListSelected === false)
	{
		$Options = '<option value="">keine Wörterlisten vorhanden</option>';
	}
	return array($Select.$Options.'</select>',$ListSelected,$L1,$L2,$ListName);
}
function MakeButton($Name,$Value,$Action,$Type = "submit",$SizeClass = "Medium",$Attributes="",$ButtonType = 1)
{
	return '<button name="'.$Name.'" id="'.$Name.'" type="'.$Type.'" class="Button'.$ButtonType.$SizeClass.'" onclick="'.$Action.'this.blur();" '.$Attributes.'>'.$Value.'</button>';
}
function GetFavorites()
{
	global $Favorites,$DBConnection;
		$List = '';
	if(isset($Favorites))
	{
		$query = "SELECT ID,Name FROM lists WHERE Deleted=0";
		$result = $DBConnection->query($query) or die("Fehler!");
		$Lists = array();
		while($row = $result->fetch_assoc())
		{
			$Lists[(int)$row["ID"]] = $row["Name"];
		}
		foreach($Favorites as $F)
		{
			if(isset($Lists[$F[0]]))
			{
				$List .= '<li id="'.MaskHTML($F[0]).'" class="'.MaskHTML($F[1]).'.'.$F[2].'">'.$Lists[$F[0]].'</li>';
			}
		}
	}
	return '<div style="width:24px;height:20px;position:absolute;"><div id="FavoritesWrapper" class="FavoritesWrapper" style="'.($List==""?'display:none;':'').'">'.
				MakeBox("FAVORITEN",''.
					'<ul id="Favorites" class="Favorites">'.
						$List.
					'</ul>'.
					'<div style="margin-left:5px;text-align:center;margin-top:20px;">' . 
						'<form id="LearnFavoritesForm" action="wdlearn.php" method="POST">'.
							
							MakeButton("LearnFavorites","Favoriten lernen!",'Fav.setCookie();',"submit","Medium").
						'</form>'.
					'</div>'.
					'<img  id="bin" src="inc/img/bin.png" onmouseover="this.src=\'inc/img/bin_glow.png\'" onmouseout="this.src=\'inc/img/bin.png\'" style="margin-top:20px;cursor:pointer;margin-left:49px;" onclick="Fav.deleteAll();" title="Favoriten löschen"/>'.
					'<ul style="display:none;" id="binlist"></ul>'.
					'<script type="text/javascript">'.
						'Fav = new FavoritesController;'.
					'</script>'
				,200).'</div></div>';
}
function ToInt($str,$bla = "")
{
	return (int)$str;
}
function MakeHiddenInput($Name,$Value)
{
	return '<input type="hidden" value="'.MaskHTML($Value).'" name="'.$Name.'" id="'.$Name.'" />';
}
function print_a($subject){
	echo str_replace("=>","&#8658;",str_replace("Array","<font color=\"red\"><b>Array</b></font>",nl2br(str_replace(" "," &nbsp; ",print_r($subject,true)))));
}
function SetArrayPointer(&$array,$key) { 
    reset ($array); 
    while (key($array) !== $key) { 
        if (next($array) === false) throw new Exception('Invalid key'); 
    } 
}
function PromptCategoryPWBox()
{
	return '<div class="Layer" id="TypePW" style="visibility:hidden;z-index:1;">'.
		MakeBox("PASSWORT",
			'<form id="TypePWForm" method="POST" onsubmit="PromptPWSubmitAction();return false;" action="wdmain.php">'.
				'<div style="font-size:0.9em;margin-bottom:15px;color:#FFFFFF;">Die ausgew&auml;hlte Kategorie ist passwortgesch&uuml;tzt! Bitte geben Sie das Passwort ein, um fortzufahren.</div>'.
				'<div class="Row">' . 
					'<div >Passwort</div>'.
					'<input type="text" id="PW" name="PW" style="width:200px;" />'.
					
				'</div>'.
				'<div style="text-align:center;">' . 
					MakeButton("SavePW","OK",'return false;',"submit","Small").
				'</div>'.
			'</form>',
		380,'hidelayer(\'TypePW\');').'</div>';
}
?>