<?php
// Author      : Esteban Marin - estebanmarin@gmx.ch
// Version     : 2.0
// License     : GNU LGPL (http://www.gnu.org/copyleft/lesser.html)
// 	----------------------------------------------------------------------------
//  Copyright (C) Esteban Marin
// 	
// 	This program is free software: you can redistribute it and/or modify
// 	it under the terms of the GNU Lesser General Public License as published by
// 	the Free Software Foundation, either version 2.1 of the License, or
// 	(at your option) any later version.
// 	
// 	This program is distributed in the hope that it will be useful,
// 	but WITHOUT ANY WARRANTY; without even the implied warranty of
// 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// 	GNU Lesser General Public License for more details.
// 	
// 	You should have received a copy of the GNU Lesser General Public License
// 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 	
// 	See LICENSE.TXT file for more information.
//  ----------------------------------------------------------------------------
//
require('inc/php/init.php');

function MakeAddEditForm($CategoryID,$ListName,$Author,$Words,$Action,$NumberOfFields,$L1,$L2,$EditListID = 0,$OldCategoryPW='',$NewCategoryPW='')
{
	
	global $SchoolID;
	$WordListTable = ''.
			'<div class="AddEditTable">'.
				'<div class="Row1" style="background-color:#577AA6;border-bottom:1px solid #333333;height:30px;line-height:30px;">'.
					'<div class="ID" style="color:#FFFFFF;">Nr.</div>'.
					'<input type="text" name="L1" id="L1" class="L1" value="'.MaskHTML($L1).'" onfocus="(this.value==\'Sprache 1\'?this.value=\'\':this)" onblur="(this.value==\'\'?this.value=\'Sprache 1\':this)" />'.
					'<input type="text" name="L2" id="L2" class="L2" style="margin-right:8px;" value="'.MaskHTML($L2).'" onfocus="(this.value==\'Sprache 2\'?this.value=\'\':this)" onblur="(this.value==\'\'?this.value=\'Sprache 2\':this)" />'.
					'<span style="font-size:0.9em;">Kommentar</span>'.
				'</div>';
	
	for($i=0;$i<$NumberOfFields;$i++)
	{
		if(isset($Words[$i]))
		{
			$tmp1 = $Words[$i][0];
			$tmp2 = $Words[$i][1];
			$tmp3 = $Words[$i][2];
		}
		else
		{
			$tmp1 = "";
			$tmp2 = "";
			$tmp3 = "";
		}
		$WordListTable .= ''.
		'<div class="Row'.($i%2==0?1:2).'">'.
			'<div class="ID">'.($i+1).'</div>'.
			'<input type="text" class="L1" name="Words['.$i.'][L1]" id="Words['.$i.'][L1]" value="'.MaskHTML($tmp1).'" />'.
			'<input type="text" class="L2" name="Words['.$i.'][L2]" id="Words['.$i.'][L2]" value="'.MaskHTML($tmp2).'" />'.
			'<input type="text" class="Comment" name="Words['.$i.'][Comment]" id="Words['.$i.'][Comment]" value="'.MaskHTML($tmp3).'" />'.
		'</div>';
	}
	
	
	
	
	
	
	
	
	
	
	$WordListTable .= '</div>';
	return 	''.
	'<form name="AddEditForm" id="AddEditForm" action="wdaddedit.php" method="POST" onsubmit="" >'.
		'<div style="width:420px;margin-left:auto;margin-right:auto;">'.
			'<div class="Row">' . 
				'<div>Kategorie</div>'.
				GetCategorySelector($SchoolID,$CategoryID,"CategoryID",'style="width:260px;" onchange="AddEditCheckForPW();"').
			'</div>'.
			'<div class="Row">' . 
				'<div>Bezeichnung</div>'.
				'<input type="text" name="ListName" id="ListName" style="width:255px;" value="'.MaskHTML($ListName).'" />'.
			'</div>'.
			'<div class="Row">' . 
				'<div>Autor</div>'.
				'<input type="text" name="Author" id="Author" style="width:255px;'.($Action=="Edit"?'background-color:#CCCCCC;':'').'" value="'.MaskHTML($Author).'" '.($Action=="Edit"?'disabled="disabled"':'').'/>'.
			'</div>'.
			'<div style="font-size:0.9em;margin-top:15px;margin-bottom:15px;">Hinweis: Synonyme werden durch einen Schr&auml;gstrich &quot;/&quot; getrennt.</div>'.
		'</div>'.
		$WordListTable.
		MakeHiddenInput("Action",$Action).
		MakeHiddenInput("CategoryID",$CategoryID).
		MakeHiddenInput("EditListID",$EditListID).
		MakeHiddenInput("NumberOfFields",$NumberOfFields).
		MakeHiddenInput("OldCategoryPW",$OldCategoryPW).
		MakeHiddenInput("NewCategoryPW",$NewCategoryPW).
		'<div style="text-align:center;">'.	
			MakeButton("AddTenLines","+10 W&ouml;rter","","submit","Medium").'<img src="inc/img/clear.gif" width="10" />'.
			MakeButton("Save","speichern","this.form.Action.value='".$Action."Save';this.form.submit();","button","Medium").
		'</div>'.
	'</form>'.
	PromptCategoryPWBox()
			
					;
}
if(isset($_POST["Action"])&&$_POST["Action"]!="")
{
	echo GetHeader("worddriller",'',false);
	$Body = "";
	switch($_POST["Action"])
	{
		case "New": $Action = "New";break;
		case "NewSave" : $Action = "NewSave";break;
		case "Edit" : $Action = "Edit";break;
		case "EditSave": $Action = "EditSave";break;
		default: $Action = "none";
	}
	$EditListID = 0;
	$OldCategoryPW = "";
	$NewCategoryPW = "";
	$OldPWOK = false;
	$NewPWOK = false;
	$ListName = "";
	$L1 = "";
	$L2 = "";
	$Author = "";
	$ErrMsg = '';
	$CategoryID = 0;
	$Words = array();
	
	if($Action!="none")
	{
		$BoxContent = "";
		$BoxTitle = "";
		
		if(isset($_POST["OldCategoryPW"]))
		{
			$OldCategoryPW = $_POST["OldCategoryPW"];
		}
		elseif(isset($_POST["NewListCategoryPW"]))
		{
			$OldCategoryPW = $_POST["NewListCategoryPW"];
		}
		elseif(isset($_POST["EditListCategoryPW"]))
		{
			$OldCategoryPW = $_POST["EditListCategoryPW"];
		}
		if(isset($_POST["NewCategoryPW"]))
		{
			$NewCategoryPW = $_POST["NewCategoryPW"];
		}
		else
		{
			$NewCategoryPW = $OldCategoryPW;
		}
		
		
		if(($Action=="Edit"||$Action=="EditSave"))
		{
			if(isset($_POST["EditListID"]))
			{
				$EditListID = (int)$_POST["EditListID"];
				
			}
			$BoxHeader = "W&Ouml;RTERLISTE BEARBEITEN";
			$query = "SELECT lists.Name as ListName, lists.L1 AS L1, lists.L2 AS L2, lists.Author as Author,categories.ID AS CategoryID, categories.Password AS Password FROM lists,categories WHERE lists.ID = ".(int)$EditListID." AND lists.Category = categories.ID and lists.Deleted= 0";
			$result = $DBConnection->query($query) or die($query);
			if($row = $result->fetch_assoc())
			{
				$ListName = $row["ListName"];
				$L1 = $row["L1"];
				$L2 = $row["L2"];
				$Author = $row["Author"];
				$CategoryID = $row["CategoryID"];
				if(md5($OldCategoryPW)==$row["Password"])
				{
					$OldPWOK = true;
					if(!(isset($_POST["Words"])&&is_array($_POST["Words"])&&count($_POST["Words"])>0))
					{
						$query = "SELECT * FROM `".(int)$EditListID."`";
						$result = $DBConnection->query($query) or die($query);
						while($row = $result->fetch_assoc())
						{
							$Words[] = array($row["L1"],$row["L2"],$row["comment"]);
						}
					}
				}
			}
			
		}
		else
		{
			if(isset($_POST["NewListName"]))
			{
				$ListName = $_POST["NewListName"];
			}
			if(isset($_POST["NewListCategoryID"]))
			{
				$CategoryID = (int)$_POST["NewListCategoryID"];
			}
			elseif(isset($_POST["CategoryID"]))
			{
				$CategoryID = (int)$_POST["CategoryID"];
			}
			$query = "SELECT Password FROM categories WHERE categories.ID=".(int)$CategoryID;
			$result = $DBConnection->query($query) or die($query);
			if($row=$result->fetch_assoc())
			{
				
				if(md5($OldCategoryPW)==$row["Password"])
				{
					
					$OldPWOK= true;
				}
				
			}
			$BoxHeader = "W&Ouml;RTERLISTE HINZUF&Uuml;GEN";
			$L1 = "Sprache 1";
			$L2 = "Sprache 2";
		}
		
		if(isset($_POST["ListName"]))
		{
			$ListName = $_POST["ListName"];
		}
		
		if(isset($_POST["Author"]))
		{
			$Author = $_POST["Author"];
		}
		if(isset($_POST["L1"]))
		{
			$L1 = $_POST["L1"];
		}
		if(isset($_POST["L2"]))
		{
			$L2 = $_POST["L2"];
		}
		
		if(isset($_POST["CategoryID"]))
		{
			$CategoryID = (int)$_POST["CategoryID"];
		}
		
		if((isset($_POST["Words"])&&is_array($_POST["Words"])&&count($_POST["Words"])>0&&count($_POST["Words"])<10000))
		{
			foreach($_POST["Words"] as $Word)
			{
				
				if(isset($Word["L1"],$Word["L2"],$Word["Comment"])&&$Word["L1"]!=""&&$Word["L2"]!="")
				{
					$Words[] = array($Word["L1"],$Word["L2"],$Word["Comment"]);
				}
			}
		}
		if(isset($_POST["NumberOfFields"])&&$_POST["NumberOfFields"]>=count($Words)&&$_POST["NumberOfFields"]<10000)
		{
			$NumberOfFields = (int)$_POST["NumberOfFields"];
		}
		else $NumberOfFields = count($Words)+10-count($Words)%10;
		if($NumberOfFields<20) $NumberOfFields = 20;
		if(isset($_POST["AddTenLines"]))
		{
			$NumberOfFields = $NumberOfFields + 10;
		}
		
		if(($Action=="Edit"||$Action=="New")&&$OldPWOK)
		{
			
			$BoxContent .= MakeAddEditForm($CategoryID,$ListName,$Author,$Words,$Action,$NumberOfFields,$L1,$L2,$EditListID,$OldCategoryPW,$NewCategoryPW);
		}
		elseif(($Action=="EditSave"||$Action=="NewSave")&&$OldPWOK)
		{
			$query = "SELECT categories.Password AS Password FROM categories WHERE categories.ID = ".(int)$CategoryID;
			$result = $DBConnection->query($query) or die($query);
			if($row=$result->fetch_assoc())
			{
				
				if(md5($NewCategoryPW)==$row["Password"])
				{
					
					$NewPWOK= true;
				}
				
			}
			if($NewPWOK===true)
			{
				if($ListName=="")
				{
					$ErrMsg .= 'Keine Listenbezeichnung angegeben!<br />';
				}
				if(count($Words)<1)
				{
					$ErrMsg .= 'Keine W&ouml; angegeben!<br />';
				}
				if($L1=="Sprache 1")
				{
					$ErrMsg .= 'Keine Sprache für die erste Spalte angegeben!<br />';
				}
				if($L2=="Sprache 2")
				{
					$ErrMsg .= 'Keine Sprache für die zweite Spalte angegeben!<br />';
				}
				if($ErrMsg=='')
				{
					
					
					
					if($Action=="EditSave")
					{
						$query = "DROP TABLE IF EXISTS `".(int)$EditListID."`";
						$DBConnection->query($query) or die($query);
						$query = "UPDATE lists SET " . 
						"Name = '".EscapeString($ListName)."',".
						"L1 = '".EscapeString($L1)."',".
						"L2 = '".EscapeString($L2)."',".
						"Category = ".(int)$CategoryID." ".
						"WHERE lists.ID = ".(int)$EditListID." AND lists.Deleted=0";
						$DBConnection->query($query) or die($query);
						
					}
					else
					{
						$query = "INSERT INTO lists " . 
						"(" . 
							"Name," . 
							"L1," . 
							"L2," . 
							"Author," . 
							"Category," . 
							"Deleted" . 
						") VALUES ".
						"(".
							"'".EscapeString($ListName)."',".
							"'".EscapeString($L1)."',".
							"'".EscapeString($L2)."',".
							"'".EscapeString($Author)."',".
							"".(int)$CategoryID.",".
							"0".
						")";
						$DBConnection->query($query) or die($query);
						$EditListID = $DBConnection->insert_id;
					}
					$query = "CREATE TABLE `".($EditListID)."` ("
					. ' `ID` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, '
					. ' `L1` TEXT NOT NULL, '
					. ' `L2` TEXT NOT NULL, '
					. ' `comment` TEXT NULL'
					. ' )'
					. ' ENGINE = MYISAM';
					$DBConnection->query($query) or die($query);
					
					
					$query = "INSERT INTO `".($EditListID)."` ".
					"(L1,L2,comment) VALUES ";
					$tmp = array();
					foreach($Words as $Word)
					{
						$tmp[] = "('".EscapeString($Word[0])."','".EscapeString($Word[1])."','".EscapeString($Word[2])."')";
					}
					$query .= implode(",",$tmp);
					$DBConnection->query($query) or die($query);
					$BoxContent .= '<p>'.($Action=="EditSave"?'Die W&ouml;rterliste &quot;'.MaskHTML($ListName).'&quot; wurde angepasst. ':'Die W&ouml;rterliste &quot;'.MaskHTML($ListName).'&quot; wurde erstellt. ').'<br /><a href="wdmain.php?LearnListID='.(int)$EditListID.'&LearnCategoryID='.(int)$CategoryID.'" style="color:#FFFFFF;font-size:0.9em">&larr; Home</a>'.'</p>';
				}
			}
			else $ErrMsg .= 'Falsches Passwort f&uuml;r die ausgew&auml;hlte Kategorie!<br />';
		}
		elseif($CategoryID==0) $ErrMsg .= 'Keine Kategorie ausgew&auml;hlt!<br />';
		else $ErrMsg .= 'Falsches Passwort f&uuml;r die ausgew&auml;hlte Kategorie!<br />';
		
		
		if($ErrMsg != '')
		{
			$BoxContent .= '<p>'.$ErrMsg.' <a href="wdmain.php" style="color:#FFFFFF;" onclick="history.back();return false;">zur&uuml;ck!</a></p>';
		}
		$Box = MakeBox($BoxHeader, $BoxContent,660);
		
		$Body .= $Box;
	}
	

	$Layers = "";
	echo GetBody($Body.
	'<div style="margin-top:10px;margin-left:20px;">'.
		'<a href="wdmain.php?LearnListID='.(int)$EditListID.'&LearnCategoryID='.(int)$CategoryID.'" style="color:#FFFFFF;font-size:0.9em">&larr; Home</a>'.
	'</div>'
	,700,false,$Layers);
}
else
{
	header("Location: wdmain.php");
}
?>