<?php
// Author      : Esteban Marin - estebanmarin@gmx.ch
// Version     : 2.0
// License     : GNU LGPL (http://www.gnu.org/copyleft/lesser.html)
// 	----------------------------------------------------------------------------
//  Copyright (C) Esteban Marin
// 	
// 	This program is free software: you can redistribute it and/or modify
// 	it under the terms of the GNU Lesser General Public License as published by
// 	the Free Software Foundation, either version 2.1 of the License, or
// 	(at your option) any later version.
// 	
// 	This program is distributed in the hope that it will be useful,
// 	but WITHOUT ANY WARRANTY; without even the implied warranty of
// 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// 	GNU Lesser General Public License for more details.
// 	
// 	You should have received a copy of the GNU Lesser General Public License
// 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 	
// 	See LICENSE.TXT file for more information.
//  ----------------------------------------------------------------------------
//
require('inc/php/init.php');

$Position = array($LearnListID,1);

if(isset($_GET['mode'])){
	$mode = $_GET['mode'];
}
elseif(isset($_POST['mode'])){
	$mode = $_POST['mode'];
}
elseif(isset($_POST['Mode'])){
	$mode = $_POST['Mode'];
}
else $mode = "l1l2";

switch($mode){
	case "l1l2" : $modenum[0] = 0;$modenum[1] = 1;break;
	case "l2l1" : $modenum[0] = 1;$modenum[1] = 0;break;
}
//get shuffle
if(isset($_POST['shuffle'])){
	$shuffle = true;
}
else $shuffle = false;

if(isset($_GET['reload_only'])&&$_GET['reload_only']=="1"){
	$reload_only = true;
}
else $reload_only = false;
//get all lists
$ListIndex = array();
if(isset($Favorites)&&count($Favorites)>0&&isset($_POST["LearnFavorites"]))
{
	$ListsToLearn = $Favorites;
	$FirstList = reset($ListsToLearn);
	$mode = ($FirstList[1]=='l1l2'?'l1l2':'l2l1');
	switch($mode){
		case "l1l2" : $modenum[0] = 0;$modenum[1] = 1;break;
		case "l2l1" : $modenum[0] = 1;$modenum[1] = 0;break;
	}
	$shuffle = $FirstList[2]==1;
	$LearnListID = (int)$FirstList[0];
	foreach($Favorites as $Key=>$Favorite)
	{
		$ListIndex[] = (int)$Key;
	}
	
}
elseif(isset($_POST["ListsToLearn"]))
{
	$RawList = $_POST["ListsToLearn"];
	$RawList2 = explode(";",$RawList);
	$ListsToLearn = array();
	foreach($RawList2 as $F)
	{
		$temp = explode(".",$F);
		if(count($temp)==3)
		{
			$ListsToLearn[$temp[0]] = array($temp[0],$temp[1],$temp[2]);
			$ListIndex[] = (int)$temp[0];
		}
	}
}
else
{
	$ListsToLearn[$LearnListID] = array($LearnListID,$mode,(int)$shuffle);
	$ListIndex[] = (int)$LearnListID;
}

if(isset($ListsToLearn[$LearnListID]))
{
	$CurrentList = array($LearnListID,$ListsToLearn[$LearnListID][1],$LearnListID[$LearnListID][2]);
}
else $CurrentList = array($LearnListID,$mode,$shuffle);
$HideWordInput = false;
$listlength = 1;
$WordsDone = array($LearnListID=>array());
$Errors = array();
$ShowEndOptions = false;
if(isset($_POST["WordsDone"]))
{
	$tmp = explode(';',trim($_POST["WordsDone"],';'));
	foreach($tmp as $word)
	{
		
		$tmp2 = explode(".",$word);
		if(count($tmp2)==3)
		{
			//get all words done (by list) and check if correct or not
			$WordsDone[(int)$tmp2[0]][(int)$tmp2[1]] = ($tmp2[2]==1?1:0);
			
			if($tmp2[2]==0)
			{
				$Errors[(int)$tmp2[0]][(int)$tmp2[1]] = (int)$tmp2[1];
			}
		}
	}
}
if(isset($_POST["Word"]))
{
	$WordTyped = $_POST["Word"];
}
else $WordTyped = '';

$WordID = 0;
if(isset($_POST["WordID"]))
{
	$WordID = (int)$_POST["WordID"];
}


if(isset($_POST["Relearn"])&&$_POST["Relearn"]=="1"&&isset($_POST["RelearnItems"])&&$_POST["RelearnItems"]!=""&&isset($_POST["RelearnItemsDone"]))
{
	$RelearnList = true;
	$Relearn = true;
	$RelearnItems = explode(";",trim($_POST["RelearnItems"],";"));
	$tmp = explode(";",trim($_POST["RelearnItemsDone"],";"));
	$RelearnItemsDone = array();
	$RelearnItemsErrors = array();
	foreach($tmp as $Item)
	{
		$tmp2 = explode(".",$Item);
		if(count($tmp2)==2)
		{
			$RelearnItemsDone[$tmp2[0]] = (int)$tmp2[1];
			if($tmp2[1]==0)
			{
				$RelearnItemsErrors[] = (int)$tmp2[0];
			}
		}
	}
	//protect against SQL injection!!
	array_walk($RelearnItems,"ToInt");
}
else
{
	$Relearn = false;
	$RelearnItems = array();
	$RelearnItemsDone = array();
	$RelearnItemsErrors = array();
	
	$Relearn = false;
}

//get listname
$query = "SELECT ID,Name,L1,L2,Author,Category FROM lists WHERE ID = ".(int)$LearnListID;
$result = $DBConnection->query($query) or die("Fehler!");
if($row = $result->fetch_assoc())
{
	$LearnListID = $row["ID"];
	$ListName = $row["Name"];
	$L1 = $row["L1"];
	$L2 = $row["L2"];
	$Author = $row["Author"];
	$LearnCategoryID = $row["Category"];
}
$listfinished = false;


if($LearnListID>0)
{
	
	
		
	if($shuffle){
		if($Relearn){
			$relearnlistcondition = " WHERE ID=".implode(" OR ID=",$RelearnItems);
		}
		else $relearnlistcondition="";

		//get data
		$query = "SELECT * FROM `".(int)($LearnListID)."`".$relearnlistcondition;
		$result = $DBConnection->query($query) or die("Fehler!");
		//write to array
		$i=0;
		$WordToCompare = array("","");
		while ($row = $result->fetch_assoc()) {
			$wordlist[$modenum[0]][$row["ID"]]=$row["L1"];
			$wordlist[$modenum[1]][$row["ID"]]=$row["L2"];
			$wordlist[2][$row["ID"]]=$row["ID"];
			$wordlist[3][$row["ID"]]=$row["comment"];
			if($WordID>0&&$WordID==(int)$row["ID"])
			{
				$WordToCompare = array($row["L1"],$row["L2"]);
				
			}
			$i++;
		}
		
		$listlength = count($wordlist[2]);
		$currentword = $WordID;
		
		//check!
		$wordtocheck = explode("/",$WordToCompare[$modenum[1]]);

		$youranswer=false;
		$i=0;
		while($i<count($wordtocheck)){
			if($youranswer!=true){
				if(!$reload_only){
					if(trim((string)$wordtocheck[$i]) == trim((string)$WordTyped)){
						$youranswer = true;
						break;
					}
				}
				elseif(!$Relearn){
					if(isset($Errors[$LearnListID][$WordID])) {
						$youranswer = false;
						break;
					}
					else {
						$youranswer = true;
						break;
					}
	
				}
				else{
					if(isset($RelearnItemsErrors[$WordID])) {
						$youranswer = false;
						break;
					}
					else {
						$youranswer = true;
						break;
					}
	
				}
			}
			else{
				break;
	
			}
		$i++;
		}
		if(!$reload_only&&$WordID>0)
		{
			if(!$Relearn)
			{
				//put into the list "words done"
				$WordsDone[$LearnListID][$WordID] = (int)$youranswer;
				if(!$youranswer)
				{
					$Errors[$LearnListID][$WordID] = $WordID;
				}
			}
			else
			{
				$RelearnItemsDone[$WordID] = (int)$youranswer;
				if(!$youranswer)
				{
					$RelearnItemsErrors[$WordID] = $WordID;
				}
			}
			
		}
		
		
		//get a shuffled word
		
		if((!$Relearn&&isset($WordsDone[$LearnListID])&&count($WordsDone[$LearnListID])>=$listlength)||($Relearn&&isset($RelearnItemsDone)&&count($RelearnItemsDone)>=$listlength)){
			$nextwordid = $WordID;
			if(!$reload_only)
			{
				
				$listfinished = true;
			}
			
		}
		elseif(isset($WordsDone[$LearnListID])){
			
			
			if($Relearn)
			{
				$wordsremaining = array_diff_key($wordlist[2], $RelearnItemsDone);
				
			}
			else
			{
				$wordsremaining = array_diff_key($wordlist[2], $WordsDone[$LearnListID]);
			}
			
			if(!$reload_only){
				$nextwordid = $wordsremaining[array_rand($wordsremaining)];
			}
			else $nextwordid = $WordID;
		}
		else
		{
			$wordsremaining = $wordlist[2];
			
			if(!$reload_only){
				$nextwordid = $wordsremaining[array_rand($wordsremaining)];
				
			}
			else $nextwordid = $WordID;
		}
		$nextword = array($wordlist[0][array_search($nextwordid,$wordlist[2])],$wordlist[3][array_search($nextwordid,$wordlist[2])]);
		
		
	}
	else{
		if($Relearn){
			$relearnlistcondition = " AND (ID=".implode(" OR ID=",$RelearnItems).")";
		}
		else $relearnlistcondition="";

		//wörter auslesen
		$query = "SELECT * FROM `".(int)($LearnListID)."` WHERE ID >= ".(int)$WordID." " . $relearnlistcondition. " ORDER BY ID ASC LIMIT 2";
		$result = $DBConnection->query($query)  or die($DBConnection->error);
		

		$i=0;
		$WordToCompare = array("","");
		
		while ($row = $result->fetch_assoc()) {
			$wordlist[$modenum[0]][$i]=$row["L1"];
			$wordlist[$modenum[1]][$i]=$row["L2"];
			$wordlist[2][$i]=$row["ID"];
			$wordlist[3][$i]=$row["comment"];
			if($WordID>0&&$WordID==(int)$row["ID"])
			{
				$WordToCompare = array($row["L1"],$row["L2"]);
				
			}
			$i++;
			
			
		}
		$currentword = $WordID;
		if($WordID==0)
		{
			//if it is the first word
			$wordlist[0][1] = $wordlist[0][0];
			$wordlist[1][1] = $wordlist[1][0];
			$wordlist[2][1] = $wordlist[2][0];
			$wordlist[3][1] = $wordlist[3][0];
		}
		$wordtocheck = explode("/",$WordToCompare[$modenum[1]]);

		
		//check!
		$youranswer=false;
		$i=0;
		while($i<count($wordtocheck)){
			if($youranswer!=true){
				if(!$reload_only){
					if(trim((string)$wordtocheck[$i]) == trim((string)$WordTyped)){
						$youranswer = true;
						break;
					}
				}
				elseif(!$Relearn){
					if(isset($Errors[$LearnListID][$WordID])) {
						$youranswer = false;
						break;
					}
					else {
						$youranswer = true;
						break;
					}
	
				}
				else{
					if(isset($RelearnItemsErrors[$WordID])) {
						$youranswer = false;
						break;
					}
					else {
						$youranswer = true;
						break;
					}
	
				}
			}
			else{
				break;
	
			}
		$i++;
		}
		if(!$reload_only&&$WordID>0)
		{
			if(!$Relearn)
			{
				//put into the list "words done"
				$WordsDone[$LearnListID][$WordID] = (int)$youranswer;
				if(!$youranswer)
				{
					$Errors[$LearnListID][$WordID] = $WordID;
				}
			}
			else
			{
				$RelearnItemsDone[$WordID] = (int)$youranswer;
				if(!$youranswer)
				{
					$RelearnItemsErrors[$WordID] = $WordID;
				}
			}
			
		}
		
		//get length of the list
		if($relearnlistcondition!="") $relearnlistcondition = "WHERE 1 ".$relearnlistcondition;
		$query = "SELECT ID FROM `".(int)($LearnListID)."` ".$relearnlistcondition ;
		$result = $DBConnection->query($query)or die($DBConnection->error);
		
		$listlength=$result->num_rows;
		if((!$Relearn&&isset($WordsDone[$LearnListID])&&count($WordsDone[$LearnListID])>=$listlength)||($Relearn&&isset($RelearnItemsDone)&&count($RelearnItemsDone)>=$listlength)){
			$nextwordid = $WordID;
			if(!$reload_only)
			{
				$listfinished = true;
			}
		}
		else
		{
			
			if(!$reload_only){
				
				$nextwordid = $wordlist[2][1];
			}
			else $nextwordid = $WordID;
		}
		$nextword = array($wordlist[0][array_search($nextwordid,$wordlist[2])],$wordlist[3][array_search($nextwordid,$wordlist[2])]);
		
	}

	
	
	
	
	

	function GetGrade($f){
		if($f>=100)
		{
			return "Ober-Guru";
		}
		elseif($f>=80)
		{
			return "K&ouml;nner";
		}
		elseif($f>=60)
		{
			return "Fortgeschrittener";
		}
		elseif($f>=40)
		{
			return "Dilettant";
		}
		else
		{
			return "Analphabet";
		}
			
	}
	function MakeErrorlist($errorlist,$ListID = 0)
	{
		$tmp = array();
		foreach($errorlist as $list=>$errors)
		{
			if($ListID == 0 || $list == $ListID)
			{
				foreach($errors as $error)
				{
					$tmp[] = $list.".".$error;
					
				}
			}
		}
		return implode(";",$tmp);
	}
	function MakeWordsDoneList($wordsdonelist)
	{
		$tmp = array();
		foreach($wordsdonelist as $list=>$words)
		{
			foreach($words as $wordid=>$correct)
			{
				$tmp[] = MaskHTML($list.".".$wordid.".".(int)$correct);
				
			}
		}
		return implode(";",$tmp);
	}
	
	function MakeRelearnWordsDoneList($wordsdonelist)
	{
		$tmp = array();
		foreach($wordsdonelist as $item=>$correct)
		{
			
			$tmp[] = MaskHTML($item.".".$correct);
				
			
		}
		return implode(";",$tmp);
	}
	function CountWordsToLearn($ListsToLearn)
	{
		$i = 0;
		foreach($ListsToLearn as $List)
		{
			$i+= count($List);
		}
		return $i;
	}
	$errorlist = MakeErrorList($Errors);
	$wordsdonelist = MakeWordsDoneList($WordsDone);
	
	$wordsdone_count = count($WordsDone);
	$overwritecontent = "";
	
	if(!$Relearn&&isset($Errors[$LearnListID]))
	{
		$numerrors = count($Errors[$LearnListID]);
	}
	elseif($Relearn&&isset($RelearnItemsErrors))
	{
		$numerrors = count($RelearnItemsErrors);
	}
	else $numerrors = 0;
	
	$lengths = array();
	foreach($ListsToLearn as $list)
	{
		$query = "SELECT ID FROM `".(int)($list[0])."`";
		$result = $DBConnection->query($query)or die($DBConnection->error);
		
		$lengths[$list[0]]=$result->num_rows;
	}
	
	
	
	
	
	if($listfinished&&count($ListsToLearn)>1&&count($WordsDone)>=count($ListsToLearn))
	{
		$totnumerrors = count($Errors,COUNT_RECURSIVE)-count($Errors);
		echo $totnumerrors.'/'.array_sum($lengths);
		$AllListsFinishedMessage = ''.
		'<div style="margin-top:20px;margin-bottom:20px;border-top:1px solid #FFFFFF;padding-top:10px;padding-bottom:10px;font-size:1em;border-top:1px solid #FFFFFF;border-bottom:1px solid #FFFFFF;">'.
			'Sie sind mit allen '.count($ListsToLearn).' Listen fertig!<br />'.
			'Gesamtergebnis: <strong>'.GetGrade((100-($totnumerrors)/array_sum($lengths)*100)).'</strong> ('.substr((100-($totnumerrors)/array_sum($lengths)*100),0,5).'% korrekt)'.
			($totnumerrors>0?'<div style="margin-top:15px;"><strong><a style="color:#FFFFFF;" href="wdprintlist.php?errorlist=1&lists='.implode(";",$ListIndex).'&limitto='.MakeWordsDoneList($Errors).'" target="_blank">&rarr; alle Fehler ausdrucken</a></strong></div>':'').
		'</div>'
		;
	}
	else
	{
		$AllListsFinishedMessage = '';
	}
	if($youranswer){
		if(!$listfinished){
			
		}
		else{
			$HideWordInput = true;
			$ShowEndOptions = true;
			$overwritecontent = ''.
			'<div style="border-top:1px solid #FFFFFF;padding-top:10px;font-size:1em;text-align:left;margin-bottom:20px;padding-left:5px;">'.
				"Ihre letzte Antwort war korrekt! " . 
				"Sie sind jetzt fertig!<br />" . 
				"Ihr Ergebnis: <strong>".substr((100-(($numerrors/$listlength)*100)),0,5)."% korrekt</strong><br />" . 
				"Ihre Stufe: <strong>".GetGrade((100-(($numerrors/$listlength)*100)))."</strong><br />" . 
				($numerrors>0?'<div style="margin-top:15px;"><strong><a style="color:#FFFFFF;" href="wdprintlist.php?errorlist=1&lists='.(int)$LearnListID.'&limitto='.MakeWordsDoneList($Errors).'" target="_blank">&rarr; Fehler ausdrucken</a></strong></div>':'').
			'</div>';
			$errors = "";
			$wordsdone = "";
		}
	}
	else{
		if(!$listfinished){
			$overwritecontent = ''.
			'<div style="border-top:1px solid #FFFFFF;padding-top:10px;font-size:1em;text-align:left;margin-bottom:5px;padding-left:5px;">'.
				'<div style="color:#FF9933;margin-bottom:10px;">' . 
				'<strong>&quot;'.MaskHTML($WordTyped).'&quot;</strong> = falsch! <br />' . 
				'korrekt: <strong style="text-decoration:underline;">'.MaskHTML($WordToCompare[$modenum[0]])." = ".MaskHTML($WordToCompare[$modenum[1]]).'</strong>!' .
				'</div>'.
				'n&auml;chstes Wort: <strong>'.MaskHTML($nextword[0]).'</strong>'.
			'</div>'.
			'<div style="font-size:0.7em;text-align:left;margin-bottom:10px;margin-left:5px;">'.
				$nextword[1].
			'</div>' 
			;
		}
		else{
			$HideWordInput = true;
			$ShowEndOptions = true;
			
			
			$overwritecontent = '' .
			'<div style="border-top:1px solid #FFFFFF;padding-top:10px;font-size:1em;text-align:left;margin-bottom:20px;padding-left:5px;">'.
				'<div style="color:#FF9933;margin-bottom:10px;">' . 
				'<strong>&quot;'.MaskHTML($WordTyped).'&quot;</strong> = falsch! <br />' . 
				'korrekt: <strong style="text-decoration:underline;">'.MaskHTML($WordToCompare[$modenum[0]])." = ".MaskHTML($WordToCompare[$modenum[1]]).'</strong>!' .
				'</div>'.
				"Sie sind jetzt fertig!<br />" . 
				"Ihr Ergebnis: <strong>".substr((100-(($numerrors/$listlength)*100)),0,5)."% korrekt</strong><br />" . 
				"Ihre Stufe: <strong>".GetGrade((100-(($numerrors/$listlength)*100)))."</strong><br />" . 
				($numerrors>0?'<div style="margin-top:15px;"><strong><a style="color:#FFFFFF;" href="wdprintlist.php?errorlist=1&lists='.(int)$LearnListID.'&limitto='.MakeWordsDoneList($Errors).'" target="_blank">&rarr; Fehler ausdrucken</a></strong></div>':'').
			'</div>';
			
		}
	}
	function ConcatArray($Arr)
	{
		$Raw1 = array();
		foreach($Arr as $El)
		{
			$Raw1[] = implode(".",$El);
		}
		return implode(";",$Raw1);
	}
	
	SetArrayPointer($ListsToLearn,(int)$LearnListID);
	if(next($ListsToLearn))
	{
		$NextListID = key($ListsToLearn);
		$NextListMode = $ListsToLearn[$NextListID][1];
		$NextListShuffle = (int)$ListsToLearn[$NextListID][2];
	}
	else
	{
		$NextListID = 0;
		$NextListMode = '';
		$NextListShuffle = 0;
	}
	if(!$Relearn&&isset($Errors[$LearnListID]))
	{
		$RelearnItems = $Errors[$LearnListID];
		
	}
	
	$Box = MakeBox("",
		'<form id="LearnForm" name="LearnForm" method="POST" action="wdlearn.php">'.
			//'<div class="Row">' .
			'<div style="font-size:1.4em;text-align:center;margin-bottom:5px;">'.
				MaskHTML($ListName).
			'</div>'.
			'<div style="font-size:0.6em;text-align:center;margin-bottom:20px;">'.
				($Author!=''?'by '.MaskHTML($Author):'').
			'</div>'.
			($overwritecontent == ""?
				'<div style="border-top:1px solid #FFFFFF;padding-top:10px;font-size:1em;text-align:left;margin-bottom:5px;padding-left:5px;">'.
					'<strong>'.MaskHTML($nextword[0]).'</strong>'.
				'</div>'.
				'<div style="font-size:0.7em;text-align:left;margin-bottom:10px;margin-left:5px;">'.
					MaskHTML($nextword[1]).
				'</div>':
				$overwritecontent
			).
			($HideWordInput===false?'<input type="text" id="Word" name="Word" style="width:250px;margin-right:20px;" autocomplete="off" />'.MakeButton("Learn","weiter",'this.form.submit();',"submit","Small"):'').
			($ShowEndOptions?''.
			'<div style="text-align:center;">'.
				($numerrors>0?MakeButton("RelearnErrors","Fehler wiederholen",'RedoMistakes();',"button","Medium",'style="margin-right:20px;"'):'').
				(count($ListsToLearn)>1&&$NextListID>0?
					MakeButton("NextList","n&auml;chste Liste lernen",'LearnList('.(int)$NextListID.',\''.addslashes($NextListMode).'\','.$NextListShuffle.');',"button","Medium",'')
					:
					($AllListsFinishedMessage==''?MakeButton("RelearnList","Liste wiederholen",'Reset();',"button","Medium",'"'):'')
				)
			:
			'').
			'</div>'.
			$AllListsFinishedMessage.
			'<div style="font-size:0.8em;text-align:left;margin-top:20px;margin-bottom:5px">'.
				'Modus:'.
			'</div>'.
			'<p>'.
				'<label '.(!$listfinished?'onclick="javascript:wdreload();"' : '').' style="cursor:pointer;">'.
				'<input name="mode" type="radio" id="mode_0" value="l1l2" style="margin-right:10px;margin-left:5px;" '.($mode=='l1l2'?'checked="checked"':'').' '.(!$listfinished?'onchange="javascript:wdreload();" onclick="javascript:wdreload();"':'').'/>'.
				MaskHTML($L1)." &rarr; ".MaskHTML($L2).'</label>'.
				'<br />'.
				'<label '.(!$listfinished?'onclick="javascript:wdreload();"' : '').' style="cursor:pointer;">'.
				'<input type="radio" name="mode" value="l2l1" id="mode_1" style="margin-right:10px;margin-left:5px;" '.($mode=='l2l1'?'checked="checked"':'').' '.(!$listfinished?'onchange="javascript:wdreload();" onclick="javascript:wdreload();"':'').'/>'.
				MaskHTML($L2)." &rarr; ".MaskHTML($L1).'</label>'.
			'</p>'.
			'<p style="margin-top:5px;">'.
				'<label '.($listfinished||!$shuffle?'onclick="javascript:wdreload();"':'').' style="cursor:pointer;">'.
				'<input name="shuffle" type="checkbox" id="shuffle" style="margin-right:10px;margin-left:5px;" '.($shuffle?'checked="checked"':'').' '.($shuffle&&!$listfinished?'disabled="disabled"':'').'/>'.
				'zuf&auml;llige Abfragereihenfolge</label>'.
				($shuffle&&!$listfinished?'<input type="hidden" value="checked" name="shuffle" />':'').
			'</p>'.	
			MakeHiddenInput("ListsToLearn",ConcatArray($ListsToLearn)).
			MakeHiddenInput("WordsDone",MakeWordsDoneList($WordsDone)).
			MakeHiddenInput("WordID",(int)$nextwordid).
			MakeHiddenInput("LearnListID",(int)$LearnListID).
			MakeHiddenInput("RelearnItems",implode(";",($Relearn&&$listfinished?$RelearnItemsErrors:$RelearnItems))).
			MakeHiddenInput("RelearnItemsDone",MakeRelearnWordsDoneList($RelearnItemsDone)).
			MakeHiddenInput("Relearn",($Relearn?1:0)).
		'</form>'.
		($Relearn?
		'<div style="font-size:0.8em;margin-top:10px;">'.(count($ListsToLearn)>1?'aktuelle Fehlerliste: ':'').(count($RelearnItemsDone))." / ".count($RelearnItems).'</div>'. 
		'<table cellpadding="0" cellspacing="0" border="0" width="100%">'.
			'<tr>'.
				'<td width="'.(((count($RelearnItemsDone)/*-1*/)/count($RelearnItems))*100).'%" height="15" bgcolor="#009933"></td>' .
				'<td width="'.((1-(count($RelearnItemsDone)/*-1*/)/count($RelearnItems))*100).'%" height="15" bgcolor="#999999"></td>' .
			'</tr>'.
		'</table>'
		:
		'<div style="font-size:0.8em;margin-top:10px;">'.(count($ListsToLearn)>1?'aktuelle Liste: ':'').(count($WordsDone[$LearnListID]))." / ".$listlength.'</div>'. 
		'<table cellpadding="0" cellspacing="0" border="0" width="100%">'.
			'<tr>'.
				'<td width="'.(((count($WordsDone[$LearnListID])/*-1*/)/$listlength)*100).'%" height="15" bgcolor="#009933"></td>' .
				'<td width="'.((1-(count($WordsDone[$LearnListID])/*-1*/)/$listlength)*100).'%" height="15" bgcolor="#999999"></td>' .
			'</tr>'.
		'</table>').
		(count($ListsToLearn)>1?
			'<div style="font-size:0.8em;margin-top:10px;">alle '.count($ListsToLearn).' Listen: '.CountWordsToLearn($WordsDone)." / ".array_sum($lengths).'</div>'. 
			'<table cellpadding="0" cellspacing="0" border="0" width="100%">'.
				'<tr>'.
					'<td width="'.((CountWordsToLearn($WordsDone)/array_sum($lengths))*100).'%" height="15" bgcolor="#009933"></td>' .
					'<td width="'.((1-CountWordsToLearn($WordsDone)/array_sum($lengths))*100).'%" height="15" bgcolor="#999999"></td>' .
				'</tr>'.
			'</table>'
			:''
		).
		'<script type="text/javascript">'.
			'if(document.LearnForm.Word) document.LearnForm.Word.focus();'.
			'function wdreload(){'.
				'document.LearnForm.action = "wdlearn.php?reload_only=1";'.
				'document.LearnForm.submit();'.
			'}'.
		'</script>'
	);

	echo GetHeader("worddriller",'',true);
	echo GetBody(
			$Box.
			'<div style="margin-top:10px;margin-left:20px;">'.
				'<a href="wdmain.php?LearnListID='.(int)$LearnListID.'&LearnCategoryID='.(int)$LearnCategoryID.'" style="color:#FFFFFF;font-size:0.9em">&larr; Home</a>'.
			'</div>'	
		,430,false);
	 
	
	$query="INSERT DELAYED INTO log (TS,ListID,IP) VALUES('".time()."','".(int)$LearnListID."','".getenv("REMOTE_ADDR")."')";
	$DBConnection->query($query);
}
else
{
	header("Location:wdmain.php");
	die();
}
 ?>